package pt.caf_pbs.schooldiskclient.ui;

import android.content.Intent;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.ProgressBar;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import pt.caf_pbs.schooldiskclient.R;
import pt.caf_pbs.schooldiskclient.adapter.ListViewAdapterInstructor;
import pt.caf_pbs.schooldiskclient.helper.Utils;
import pt.caf_pbs.schooldiskclient.model.Instructor;
import pt.caf_pbs.schooldiskclient.service.RequestsService;

import java.util.ArrayList;
import java.util.List;



public class InstructorsActivity extends AppCompatActivity {
    private ListView lv;
    private ProgressBar pdRing;
    private List<Instructor> instructorsList;
    private ActivityResultLauncher<Intent> someActivityResultLauncher;
    private ListViewAdapterInstructor adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_instructors);
        pdRing = (ProgressBar) findViewById(R.id.progressBar);
        pdRing.setVisibility(ProgressBar.INVISIBLE);
        lv = (ListView) findViewById(R.id.listView);
        instructorsList = new ArrayList();
        someActivityResultLauncher = registerForActivityResult(
                new ActivityResultContracts.StartActivityForResult(),
                new ActivityResultCallback<ActivityResult>() {
                    @Override
                    public void onActivityResult(ActivityResult result) {
                        if(result.getResultCode() == RESULT_OK){
                            getInstructorsFromWs();
                        }
                    }
                });
        adapter = new ListViewAdapterInstructor(this, instructorsList);
        lv.setAdapter(adapter);
        registerForContextMenu(lv);
        lv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                String initials = adapter.getInitials(i);
                String name = adapter.getName(i);
                Intent intent = new Intent(InstructorsActivity.this, InstructorDetailActivity.class);
                intent.putExtra(Utils.ID, initials);
                intent.putExtra(Utils.NAME, name);
                someActivityResultLauncher.launch(intent);
            }
        });
        getInstructorsFromWs();
    }

    private void getInstructorsFromWs() {
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);
                    }
                });
                List<Instructor> instructorDTOS = RequestsService.getInstructors(InstructorsActivity.this);
                instructorsList.clear();
                instructorsList.addAll(instructorDTOS);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        adapter.notifyDataSetChanged();
                        pdRing.setVisibility(ProgressBar.GONE);
                    }
                });
            }
        }.start();
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo) item.getMenuInfo();
        int pos = info.position;
        Intent intent;
        String initials = adapter.getInitials(pos);
        String nome = adapter.getName(pos);
        if (initials != null) {
            switch (item.getItemId()) {
                case R.id.delete:
                    intent = new Intent(InstructorsActivity.this, InstructorActivity.class);
                    intent.putExtra(Utils.ID, initials);
                    intent.putExtra(Utils.NAME, nome);
                    intent.putExtra(Utils.OPERATION, Utils.REQUEST_CODE_DELETE_ACTIVITY);
                    someActivityResultLauncher.launch(intent);
                    return true;
                case R.id.edit:
                    intent = new Intent(InstructorsActivity.this, InstructorActivity.class); //TODO: change to edit initails instructor
                    intent.putExtra(Utils.ID, initials);
                    intent.putExtra(Utils.NAME, nome);
                    intent.putExtra(Utils.OPERATION, Utils.REQUEST_CODE_EDIT_ACTIVITY);
                    someActivityResultLauncher.launch(intent);
                    return true;
                default:
                    break;
            }
        }
        return super.onContextItemSelected(item);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent;
        switch (item.getItemId()) {
            case R.id.add:
                intent = new Intent(this, InstructorActivity.class);
                intent.putExtra(Utils.OPERATION, Utils.REQUEST_CODE_ADD_ACTIVITY);
                someActivityResultLauncher.launch(intent);
                return true;
            case R.id.settings:
                intent = new Intent(this, SettingsActivity.class);
                someActivityResultLauncher.launch(intent);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.optionmenu_detail, menu);
        return true;
    }


    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        getMenuInflater().inflate(R.menu.contextmenu_detail, menu);
    }
}
